<?php

declare(strict_types=1);

namespace CGA\Sync\Enums;

use RuntimeException;

enum Operation: string
{
    case CREATE = 'create';
    case UPDATE = 'update';
    case DELETE = 'delete';

    public static function infer(?int $syncableId = null, bool $deleted = false): self
    {
        return match (true) {
            $syncableId === null && $deleted === false => self::CREATE,
            $syncableId !== null && $deleted === false => self::UPDATE,
            $syncableId !== null && $deleted === true => self::DELETE,
            default => throw new RuntimeException('Operation could not be inferred'),
        };
    }

    public static function is(self $operation, ?int $syncableId = null, bool $deleted = false): bool
    {
        try {
            return self::infer($syncableId, $deleted) === $operation;
        } catch (RuntimeException $e) {
            return false;
        }
    }
}
