<?php

declare(strict_types=1);

namespace CGA\Sync\Contracts;

use CGA\Sync\Models\SyncDocument;
use Illuminate\Database\Eloquent\Relations\MorphOne;

/**
 * @template TModel of \Illuminate\Database\Eloquent\Model
 */
interface SyncableContract
{
    public function syncDocument(): MorphOne;

    public function getSyncDocument(): ?SyncDocument;

    public function skipSyncEvents(callable $callback): mixed;

    public static function withoutSyncEvents(callable $callback): mixed;

    public function getSyncId(): string;
}
