<?php

declare(strict_types=1);

namespace CGA\Sync\Contracts;

use Illuminate\Database\Eloquent\Model;

interface StateExtender
{
    /**
     * Extend the field data for a syncable model's state.
     *
     * @param  array<string, mixed>  $data  The current field data
     * @return array<string, mixed>  The modified field data
     */
    public function extendFieldData(Model $model, array $data): array;
}
