<?php

declare(strict_types=1);

namespace CGA\Sync\Values;

use Illuminate\Support\Collection;

class BatchItem
{
    public function __construct(
        public private(set) string $syncId,
        public private(set) Collection $document,
        public private(set) ?string $revisionId = null,
        public private(set) ?bool $deleted = false,
    ) {}

    public static function fromArray(array $data): self
    {
        return new self(
            syncId: $data['sync_id'],
            document: collect($data['data']),
            revisionId: $data['revision_id'] ?? null,
            deleted: $data['deleted'] ?? false,
        );
    }
}
