<?php

declare(strict_types=1);

namespace CGA\Sync\Http\Resources;

use CGA\Sync\Schema\SchemaResolver;
use CGA\Sync\Values\SyncableEntityType;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

/** @mixin SyncableEntityType */
class SyncableEntityTypeResource extends JsonResource
{
    public function toArray(Request $request): array
    {
        return [
            'type' => $this->type,
            'url' => route('sync.state.show', ['type' => $this->type]),
            'schema' => $this->getSchema(),
        ];
    }

    protected function getSchema(): array
    {
        $modelClass = $this->getMorphedModel();
        $model = new $modelClass();

        $schemaResolver = app(SchemaResolver::class);

        return $schemaResolver->resolve($model);
    }
}
