<?php

declare(strict_types=1);

namespace CGA\Sync\Events;

use CGA\Sync\Contracts\SyncableContract;
use Illuminate\Broadcasting\InteractsWithSockets;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Foundation\Events\Dispatchable;
use Illuminate\Queue\SerializesModels;

/**
 * Event fired when a syncable model is restored on the server side.
 * This enables bi-directional sync by tracking server-side model restoration (soft delete undo).
 */
class SyncableModelRestored
{
    use Dispatchable;
    use InteractsWithSockets;
    use SerializesModels;

    public function __construct(
        public readonly Model&SyncableContract $model
    ) {}
}
