<?php

declare(strict_types=1);

namespace CGA\Sync\Contracts;

use Illuminate\Database\Eloquent\Model;

interface SchemaHandler
{
    /**
     * Determine if this handler can process the given attribute.
     */
    public function supports(string $attribute, Model $model): bool;

    /**
     * Resolve the schema for the given attribute.
     *
     * @return array<string, mixed> The schema definition
     */
    public function resolve(string $attribute, Model $model): array;
}
