<?php

declare(strict_types=1);

use CGA\Sync\Http\Controllers\StateController;
use CGA\Sync\Http\Controllers\SyncDocumentController;
use Illuminate\Support\Facades\Route;

Route::get('/state', [StateController::class, 'index'])->name('state.index');
Route::get('/state/{type}', [StateController::class, 'show'])->name('state.show');

Route::post('/batch', [SyncDocumentController::class, 'batch'])->name('batch');
Route::put('/{syncId}', [SyncDocumentController::class, 'store'])->name('document.store');
Route::get('/{syncId}', [SyncDocumentController::class, 'show'])->name('document.show');
