<?php

declare(strict_types=1);

return [
    /**
     * The model for the sync documents and revisions.
     */
    'model' => \CGA\Sync\Models\SyncDocument::class,
    'revision_model' => \CGA\Sync\Models\SyncRevision::class,

    /**
     * The table names for the sync documents and revisions.
     */
    'table_names' => [
        'sync_documents' => 'sync_documents',
        'sync_revisions' => 'sync_revisions',
    ],

    /**
     * Whether to apply sync operations asynchronously.
     *
     * @phpstan-ignore larastan.noEnvCallsOutsideOfConfig
     */
    'async' => env('SYNC_ASYNC', true),

    /**
     * The namespaces to look for state classes in.
     */
    'state_namespaces' => [
        'App\\Support\\Sync\\Data\\States\\',
    ],

    /**
     * The namespaces to look for validator classes in.
     */
    'validator_namespaces' => [
        'App\\Support\\Sync\\Validators\\',
    ],

    /**
     * Route configuration.
     */
    'route' => [
        'prefix' => 'api/sync',
        'middleware' => ['api'],
    ],

    /**
     * The default auth driver to use.
     */
    'default_auth_driver' => null,

    /**
     * The hooks to run before and after the sync document is processed.
     */
    'hooks' => [
        // App\Support\Sync\Hooks\LoggingHook::class,
    ],

    /**
     * Schema configuration for exposing field metadata to clients.
     */
    'schema' => [
        /**
         * Schema handlers to use for resolving field metadata.
         * Handlers are executed in order, first match wins.
         */
        'handlers' => [
            \CGA\Sync\Schema\Handlers\EnumSchemaHandler::class,
        ],

        /**
         * Locales to include in schema responses.
         * Can be:
         * - Array of locale codes: ['en', 'nl', 'de']
         * - Callable that returns array: fn() => Locale::cases()
         * - Class name that when resolved returns array: App\Enums\Locale::class
         */
        'locales' => [
            'en',
        ],

        /**
         * Fallback locale to use when translation is missing.
         */
        'fallback_locale' => 'en',
    ],
];
