<?php

declare(strict_types=1);

namespace CGA\Sync;

use CGA\Sync\Facades\CauserResolver;
use CGA\Sync\Models\SyncDocument;
use CGA\Sync\Models\SyncRevision;
use Illuminate\Contracts\Auth\Authenticatable;

class Sync
{
    /**
     * @return class-string<SyncRevision>
     */
    public static function getRevisionModel(): string
    {
        return config('sync.revision_model');
    }

    /**
     * @return class-string<SyncDocument>
     */
    public static function getDocumentModel(): string
    {
        return config('sync.model');
    }

    public function saveRevision(SyncDocument $syncDocument, ?Authenticatable $causer = null): SyncRevision
    {
        $causer = $causer ?? $syncDocument->causer;

        return $syncDocument->revisions()->create([
            'sync_id' => $syncDocument->sync_id,
            'revision_id' => $syncDocument->revision_id,
            'document' => $syncDocument->document,
            'causer_type' => $causer?->getMorphClass(),
            'causer_id' => $causer?->getKey(),
        ]);
    }

    public function upsertSyncDocument(string $syncId, array $data): SyncDocument
    {
        $causer = CauserResolver::resolve();

        return self::getDocumentModel()::updateOrCreate(
            ['sync_id' => $syncId],
            array_merge($data, [
                'causer_type' => $causer?->getMorphClass(),
                'causer_id' => $causer?->getKey(),
            ]),
        );
    }
}
