<?php

declare(strict_types=1);

namespace CGA\Sync\Models;

use CGA\Sync\Facades\Sync;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\MorphTo;
use Illuminate\Support\Collection;

/**
 * @property string $revision_id
 * @property Collection $document
 * @property string $sync_id
 */
class SyncRevision extends Model
{
    protected $guarded = [];

    protected function casts(): array
    {
        return [
            'sync_id' => 'string',
            'document' => 'collection',
        ];
    }

    public function __construct(array $attributes = [])
    {
        if (! isset($this->table)) {
            $this->setTable(config('sync.table_names.sync_revisions'));
        }

        parent::__construct($attributes);
    }

    /** @return BelongsTo<SyncDocument, $this> */
    public function syncDocument(): BelongsTo
    {
        return $this->belongsTo(Sync::getDocumentModel(), 'sync_id', 'sync_id');
    }

    /** @return MorphTo<Model, $this> */
    public function causer(): MorphTo
    {
        return $this->morphTo();
    }
}
