<?php

declare(strict_types=1);

namespace CGA\Sync\Listeners;

use CGA\Sync\Events\SyncDocumentCreating;
use CGA\Sync\Facades\CauserResolver;
use CGA\Sync\Models\SyncDocument;
use CGA\Sync\Services\RevisionIdGenerator;

class PrepareSyncDocument
{
    /**
     * Handle the event.
     */
    public function handle(SyncDocumentCreating $event): void
    {
        $syncDocument = $event->syncDocument;

        $this->setRevisionId($syncDocument);
        $this->setCauser($syncDocument);
    }

    private function setRevisionId(SyncDocument $syncDocument): void
    {
        $syncDocument->revision_id ??= app(RevisionIdGenerator::class)->generateForNew($syncDocument->sync_id);
    }

    private function setCauser(SyncDocument $syncDocument): void
    {
        $causer = CauserResolver::resolve();

        $syncDocument->causer_type = $causer?->getMorphClass();
        $syncDocument->causer_id = $causer?->getKey();
    }
}
