<?php

declare(strict_types=1);

namespace CGA\Sync\Http\Resources;

use CGA\Sync\Models\SyncDocument;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

/** @mixin SyncDocument */
class SyncDocumentResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'sync_id' => $this->sync_id,
            'revision_id' => $this->revision_id,
            'status' => $this->status->value,
            'data' => $this->document,
            'updated_at' => $this->updated_at,
            'deleted' => $this->deleted,
        ];
    }
}
