<?php

declare(strict_types=1);

namespace CGA\Sync\Events;

use CGA\Sync\Contracts\SyncableContract;
use Illuminate\Broadcasting\InteractsWithSockets;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Foundation\Events\Dispatchable;
use Illuminate\Queue\SerializesModels;

/**
 * Event fired when a syncable model is updated on the server side.
 * This enables bi-directional sync by tracking server-side model updates.
 */
class SyncableModelUpdated
{
    use Dispatchable;
    use InteractsWithSockets;
    use SerializesModels;

    public function __construct(
        public readonly Model&SyncableContract $model,
        public readonly array $originalAttributes
    ) {}
}
