<?php

declare(strict_types=1);

namespace CGA\Sync\Data;

use CGA\Sync\Contracts\SyncableContract;
use Illuminate\Database\Eloquent\Model;

class StateResolver
{
    public function resolve(Model & SyncableContract $model): BaseState
    {
        $modelClass = get_class($model);
        $stateClass = $this->getStateClass($modelClass);

        return app($stateClass, ['model' => $model]);
    }

    /**
     * @param class-string<Model & SyncableContract> $modelClass
     */
    protected function getStateClass(string $modelClass): string
    {
        $modelName = class_basename($modelClass);

        foreach ($this->getStateNamespaces() as $namespace) {
            $stateClass = "{$namespace}{$modelName}State";

            if (class_exists($stateClass)) {
                return $stateClass;
            }
        }

        return BaseState::class;
    }

    protected function getStateNamespaces(): array
    {
        $defaultNamespaces = [
            'App\\Support\\Sync\\Data\\States\\',
        ];

        return config('sync.state_namespaces', $defaultNamespaces) ?? $defaultNamespaces;
    }
}
