<?php

declare(strict_types=1);

namespace CGA\Sync\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class StoreSyncDocumentBatchRequest extends FormRequest
{
    public function authorize(): bool
    {
        return true;
    }

    /**
     * @return array<string, mixed>
     */
    public function rules(): array
    {
        return [
            'documents' => 'required|array|min:1|max:50',
            'documents.*.sync_id' => 'required|string|max:255',
            'documents.*.revision_id' => 'sometimes|nullable|string',
            'documents.*.data' => 'sometimes|array',
            'documents.*.data.syncable_type' => 'sometimes|string|max:50|required_with:documents.*.data',
            'documents.*.deleted' => 'sometimes|boolean',
            'client_details' => 'sometimes|array',
        ];
    }

    /**
     * @return array<string, string>
     */
    public function messages(): array
    {
        return [
            'documents.required' => 'The documents field is required.',
            'documents.array' => 'The documents must be an array.',
            'documents.min' => 'At least one document is required.',
            'documents.max' => 'A maximum of 50 documents can be processed in a single batch.',
            'documents.*.sync_id.required' => 'Each document must have a sync_id.',
            'documents.*.sync_id.string' => 'The sync_id must be a string.',
            'documents.*.data.syncable_type.required' => 'Each document must have an syncable_type.',
            'documents.*.data.syncable_type.string' => 'The syncable_type must be a string.',
            'documents.*.revision.string' => 'The revision must be a string.',
            'documents.*.data.array' => 'The data must be an array.',
            'documents.*.deleted.boolean' => 'The deleted field must be a boolean.',
            'client_details.array' => 'The client details must be an array.',
        ];
    }
}
