<?php

declare(strict_types=1);

namespace CGA\Sync\Exceptions;

use Illuminate\Support\Facades\Log;

class UnknownSyncModelException extends SyncException
{
    public static function forType(string $type): self
    {
        return new self(__('Unknown sync model type: :type', ['type' => $type]));
    }

    public function report(): void
    {
        Log::error('Unknown sync model exception', [
            'message' => $this->getMessage(),
        ]);

        abort(404, $this->getMessage());
    }
}
