<?php

declare(strict_types=1);

namespace CGA\Sync\Contracts;

use CGA\Sync\Models\SyncDocument;
use Illuminate\Database\Eloquent\Model;

interface DocumentHandler
{
    /**
     * Determine if this handler can process the given sync document.
     */
    public function canHandle(SyncDocument $syncDocument): bool;

    /**
     * Handle the sync document processing.
     *
     * @return Model The processed entity
     * @throws \Exception When processing fails
     */
    public function handle(SyncDocument $syncDocument): Model;
}
