<?php

declare(strict_types=1);

namespace CGA\Sync\Collections;

use CGA\Sync\Contracts\SyncableContract;
use CGA\Sync\Data\StateResolver;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Pagination\AbstractCursorPaginator;
use Illuminate\Pagination\AbstractPaginator;
use Illuminate\Support\Collection;

class StateCollection extends Collection
{
    public function transformToStateData(): Collection
    {
        $stateResolver = app(StateResolver::class);

        return $this->map(fn(Model&SyncableContract $model) => $stateResolver->resolve($model));
    }

    public static function fromPaginator(AbstractPaginator|AbstractCursorPaginator $paginator): self
    {
        return new self(
            $paginator->items()
        );
    }
}
