<?php

declare(strict_types=1);

namespace CGA\Sync\Values;

use CGA\Sync\Enums\SyncResultStatus;
use Illuminate\Contracts\Support\Arrayable;
use Illuminate\Support\Collection;

class BatchResult implements Arrayable
{
    public function __construct(
        public private(set) Collection $results,
    ) {}

    public function toArray(): array
    {
        return [
            'results' => $this->results->toArray(),
        ];
    }

    public function getSuccessCount(): int
    {
        return $this->results->where('status', SyncResultStatus::SUCCESS->value)->count();
    }

    public function getErrorCount(): int
    {
        return $this->results->whereIn('status', [
            SyncResultStatus::ERROR->value,
            SyncResultStatus::CONFLICT->value,
            SyncResultStatus::VALIDATION_ERROR->value,
        ])->count();
    }

    public function hasErrors(): bool
    {
        return $this->getErrorCount() > 0;
    }
}
