<?php

declare(strict_types=1);

namespace CGA\Sync\Facades;

use CGA\Sync\Models\SyncDocument;
use CGA\Sync\Models\SyncRevision;
use Illuminate\Contracts\Auth\Authenticatable;
use Illuminate\Support\Facades\Facade;

/**
 * @see \CGA\Sync\Sync
 *
 * @method static class-string<SyncRevision> getRevisionModel()
 * @method static class-string<SyncDocument> getDocumentModel()
 * @method static SyncRevision saveRevision(SyncDocument $syncDocument, ?Authenticatable $causer = null): SyncRevision
 */
class Sync extends Facade
{
    protected static function getFacadeAccessor(): string
    {
        return \CGA\Sync\Sync::class;
    }
}
