<?php

declare(strict_types=1);

return [
    /**
     * The model for the sync documents and revisions.
     */
    'model' => \CGA\Sync\Models\SyncDocument::class,
    'revision_model' => \CGA\Sync\Models\SyncRevision::class,

    /**
     * The table names for the sync documents and revisions.
     */
    'table_names' => [
        'sync_documents' => 'sync_documents',
        'sync_revisions' => 'sync_revisions',
    ],

    /**
     * Whether to apply sync operations asynchronously.
     *
     * @phpstan-ignore larastan.noEnvCallsOutsideOfConfig
     */
    'async' => env('SYNC_ASYNC', true),

    /**
     * The namespaces to look for state classes in.
     */
    'state_namespaces' => [
        'App\\Support\\Sync\\Data\\States\\',
    ],

    /**
     * The namespaces to look for validator classes in.
     */
    'validator_namespaces' => [
        'App\\Support\\Sync\\Validators\\',
    ],

    /**
     * Route configuration.
     */
    'route' => [
        'prefix' => 'api/sync',
        'middleware' => ['api'],
    ],

    /**
     * The default auth driver to use.
     */
    'default_auth_driver' => null,
];
