<?php

declare(strict_types=1);

namespace CGA\ScopeGroups\Traits;

use CGA\ScopeGroups\Facades\ScopeGroups;
use CGA\ScopeGroups\Models\ScopeGroup;
use Illuminate\Database\Eloquent\Relations\MorphToMany;

/** @phpstan-ignore trait.unused */
trait HasScopeGroups
{
    /** @return MorphToMany<ScopeGroup, $this> */
    public function scopeGroups(): MorphToMany
    {
        return $this->morphToMany(
            ScopeGroups::getScopeGroupModel(),
            'member',
            'scope_group_memberships',
        );
    }
}
