<?php

declare(strict_types=1);

namespace CGA\ScopeGroups\Scopes;

use CGA\ScopeGroups\AccessManagers\Resolver;
use CGA\ScopeGroups\ScopeGroups;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Scope;

class IsScoped implements Scope
{
    /**
     * Apply the scope to a given Eloquent query builder.
     */
    public function apply(Builder $builder, Model $model): void
    {
        if (! ScopeGroups::isEnabled()) {
            return;
        }

        $resolver = app(Resolver::class);
        $manager = $resolver->resolve($model::class);

        $beforeResult = $manager->before();

        // true = bypass all scoping
        if ($beforeResult === true) {
            return;
        }

        // false = deny all access
        if ($beforeResult === false) {
            $builder->whereRaw('1 = 0');

            return;
        }

        // null = continue with normal scoping
        $manager->applyScope($builder);
    }
}
