<?php

declare(strict_types=1);

namespace CGA\ScopeGroups;

use CGA\ScopeGroups\Events\ScopeGroupDeleting;
use CGA\ScopeGroups\Listeners\Cleanup\ScopeGroupCleanup;
use Illuminate\Support\Facades\Event;
use Spatie\LaravelPackageTools\Package;
use Spatie\LaravelPackageTools\PackageServiceProvider;

class ScopeGroupsServiceProvider extends PackageServiceProvider
{
    public function configurePackage(Package $package): void
    {
        /*
         * This class is a Package Service Provider
         *
         * More info: https://github.com/spatie/laravel-package-tools
         */
        $package
            ->name('scope-groups')
            ->hasConfigFile()
            ->hasMigrations(
                'create_scope_groups_table',
                'create_scope_group_memberships_table',
                'create_scope_group_resources_table',
            );
    }

    public function packageBooted(): void
    {
        $this->listenToEvents();
    }

    private function listenToEvents(): void
    {
        Event::listen([ScopeGroupDeleting::class], ScopeGroupCleanup::class);
    }
}
