<?php

declare(strict_types=1);

namespace CGA\ScopeGroups;

use CGA\ScopeGroups\Models\ScopeGroup;
use CGA\ScopeGroups\Models\ScopeGroupMembership;
use CGA\ScopeGroups\Models\ScopeGroupResource;
use CGA\ScopeGroups\Services\ResolveModelsUsingTraits;
use CGA\ScopeGroups\Traits\HasScopeGroups;
use CGA\ScopeGroups\Traits\Scopeable;
use Closure;

class ScopeGroups
{
    /**
     * @return class-string<ScopeGroup>
     */
    public static function getScopeGroupModel(): string
    {
        return config('scope-groups.models.scope_group', ScopeGroup::class);
    }

    /**
     * @return class-string<ScopeGroupMembership>
     */
    public static function getScopeGroupMembershipModel(): string
    {
        return config('scope-groups.models.scope_group_membership', ScopeGroupMembership::class);
    }

    /**
     * @return class-string<ScopeGroupResource>
     */
    public static function getScopeGroupResourceModel(): string
    {
        return config('scope-groups.models.scope_group_resource', ScopeGroupResource::class);
    }

    /**
     * @return class-string<ScopeContext>
     */
    public static function getScopeContextModel(): string
    {
        return config('scope-groups.classes.scope_context', ScopeContext::class);
    }

    public static function listScopeableModels(): array
    {
        return new ResolveModelsUsingTraits(Scopeable::class)->handle(
            namespaces: config('scope-groups.scopeable_models', [
                'App\\Models\\',
            ])
        );
    }

    public static function listHasScopeGroupsModels(): array
    {
        return new ResolveModelsUsingTraits(HasScopeGroups::class)->handle(
            namespaces: config('scope-groups.has_scope_groups_models', [
                'App\\Models\\',
            ])
        );
    }

    public static function isEnabled(): bool
    {
        return config('scope-groups.enabled', true);
    }

    public static function bypassScoping(Closure $callback): void
    {
        config(['scope-groups.enabled' => false]);

        $callback();

        config(['scope-groups.enabled' => true]);
    }
}
