<?php

declare(strict_types=1);

namespace CGA\ScopeGroups\Models;

use CGA\ScopeGroups\Facades\ScopeGroups;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\MorphTo;

class ScopeGroupResource extends Model
{
    protected $guarded = [];

    public function __construct(array $attributes = [])
    {
        if (! isset($this->table)) {
            $this->setTable(config('scope-groups.table_names.scope_group_resources'));
        }

        parent::__construct($attributes);
    }

    /** @return MorphTo<Model, $this> */
    public function resource(): MorphTo
    {
        return $this->morphTo('resource');
    }

    /** @return BelongsTo<ScopeGroup, $this> */
    public function group(): BelongsTo
    {
        return $this->belongsTo(ScopeGroups::getScopeGroupModel());
    }
}
