<?php

declare(strict_types=1);

use CGA\ScopeGroups\Models\ScopeGroup;
use CGA\ScopeGroups\Models\ScopeGroupMembership;
use CGA\ScopeGroups\Models\ScopeGroupResource;
use CGA\ScopeGroups\ScopeContext;

return [

    /*
    |--------------------------------------------------------------------------
    | Enabled
    |--------------------------------------------------------------------------
    |
    | Whether the package is enabled
    */
    'enabled' => env('SCOPE_GROUPS_ENABLED', true),

    /*
    |--------------------------------------------------------------------------
    | Models namespaces
    |--------------------------------------------------------------------------
    |
    | Configure the namespaces to search for scopeable models
    */
    'model_namespaces' => [
        'App\\Models\\',
    ],

    /*
    |--------------------------------------------------------------------------
    | Models
    |--------------------------------------------------------------------------
    |
    | Configure the models used by the package
    */

    'models' => [
        'scope_group' => ScopeGroup::class,
        'scope_group_membership' => ScopeGroupMembership::class,
        'scope_group_resource' => ScopeGroupResource::class,
    ],

    /*
    |--------------------------------------------------------------------------
    | Classes
    |--------------------------------------------------------------------------
    |
    | Configure the classes used by the package
    */
    'classes' => [
        'scope_context' => ScopeContext::class,
    ],

    /*
    |--------------------------------------------------------------------------
    | Table Names
    |--------------------------------------------------------------------------
    |
    | Table names for the scope groups
    |
    */
    'table_names' => [
        'scope_groups' => 'scope_groups',
        'scope_group_memberships' => 'scope_group_memberships',
        'scope_group_resources' => 'scope_group_resources',
    ],

    /*
    |--------------------------------------------------------------------------
    | Namespaces
    |--------------------------------------------------------------------------
    |
    | Namespaces to search for AccessManager classes
    | Config namespaces are checked first, allowing project-specific overrides
    |
    */

    'access_manager_namespaces' => [
        'CGA\\ScopeGroups\\AccessManagers\\',
    ],

    /*
    |--------------------------------------------------------------------------
    | Global Hierarchy
    |--------------------------------------------------------------------------
    |
    | Global hierarchy for all scopeable models
    |
    */
    'global_hierarchy' => [],

    /*
    |--------------------------------------------------------------------------
    | Resource Hierarchy
    |--------------------------------------------------------------------------
    |
    | Define the resource hierarchy for each scopeable model
    |
    | Key: Model FQCN
    | Value: Array of model FQCNs in hierarchy order (most specific to most general)
    |
    | Order matters: resources are checked from left to right
    | - First element: direct assignment check
    | - Subsequent elements: hierarchical/relationship checks
    |
    | Example: Teacher::class => [Teacher::class, School::class, Geo::class]
    */
    'resource_hierarchy' => [],

    /*
    |--------------------------------------------------------------------------
    | Boundary Expanders
    |--------------------------------------------------------------------------
    |
    | Define the boundary expanders for each model class allowing you to
    | expand boundary IDs to be included in the query.
    |
    */
    'boundary_expanders' => [
        // Model specific expanders. i.e. Geo::class => GeoBoundaryExpander::class

        // Global expanders (checked sequentially) and used as fallback if no model specific expander is found.
        '*' => null,
    ],
];
