const prefixWithHerd = (command) => {
  const envPath = process.env.PATH

  if (!envPath) {
    throw new Error('PATH is not set in env variables')
  }

  return envPath.includes('/Herd/') || envPath.includes('/herd/') ? `herd php ${command}` : command
}

const buildPhpLintCommand = () => prefixWithHerd('./vendor/bin/phplint ./src --no-interaction --no-cache')
const buildPintCommand = () => prefixWithHerd('./vendor/bin/pint')
const buildPhpStanCommand = () => prefixWithHerd('./vendor/bin/phpstan analyse --memory-limit=2G')
const buildComposerCommand = () => 'composer validate --no-check-publish --strict'

export default {
  '*.php': [buildPhpLintCommand, buildPintCommand, buildPhpStanCommand],
  'composer.json': [buildComposerCommand],
}
