<?php

declare(strict_types=1);

namespace CGA\ScopeGroups\Models;

use CGA\ScopeGroups\Events\ScopeGroupMembershipCreated;
use CGA\ScopeGroups\Facades\ScopeGroups;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\MorphTo;

class ScopeGroupMembership extends Model
{
    protected $guarded = [];

    protected $dispatchesEvents = [
        'created' => ScopeGroupMembershipCreated::class,
    ];

    public function __construct(array $attributes = [])
    {
        if (! isset($this->table)) {
            $this->setTable(config('scope-groups.table_names.scope_group_memberships'));
        }

        parent::__construct($attributes);
    }

    /** @return BelongsTo<ScopeGroup, $this> */
    public function group(): BelongsTo
    {
        return $this->belongsTo(ScopeGroups::getScopeGroupModel());
    }

    /** @return MorphTo<Model, $this> */
    public function member(): MorphTo
    {
        return $this->morphTo('member');
    }
}
