<?php

declare(strict_types=1);

namespace CGA\ScopeGroups\Contracts;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Collection;

interface BoundaryExpander
{
    /**
     * Expand boundary IDs to include related IDs (e.g., descendants, ancestors, etc.)
     *
     * @param  class-string<Model>  $modelClass  The model class to expand boundaries for
     * @param  Collection<int>  $ids  The direct boundary IDs from scope groups
     * @return Collection<int> The expanded collection of IDs
     */
    public function expand(string $modelClass, Collection $ids): Collection;

    /**
     * Check if this expander should handle the given model class
     *
     * @param  class-string<Model>  $modelClass  The model class to check
     * @return bool True if this expander handles this model
     */
    public function handles(string $modelClass): bool;
}
