<?php

declare(strict_types=1);

namespace CGA\ScopeGroups\Database\Factories;

use CGA\ScopeGroups\Enums\Type;
use CGA\ScopeGroups\Models\ScopeGroup;
use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @template TModel of ScopeGroup
 *
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<TModel>
 */
class ScopeGroupFactory extends Factory
{
    /**
     * The name of the factory's corresponding model.
     *
     * @var class-string<TModel>
     */
    protected $model = ScopeGroup::class;

    /**
     * Define the model's default state.
     *
     * @return array<model-property<TModel>, mixed>
     */
    public function definition(): array
    {
        return [
            'name' => fake()->unique()->word(),
            'description' => fake()->sentence(),
            'type' => fake()->randomElement(Type::cases()),
        ];
    }
}
