<?php

declare(strict_types=1);

namespace CGA\ScopeGroups\Facades;

use CGA\ScopeGroups\Models\ScopeGroup;
use CGA\ScopeGroups\Models\ScopeGroupMembership;
use CGA\ScopeGroups\Models\ScopeGroupResource;
use CGA\ScopeGroups\ScopeContext;
use Illuminate\Support\Facades\Facade;

/**
 * @see \CGA\ScopeGroups\ScopeGroups
 *
 * @method static class-string<ScopeGroup> getScopeGroupModel()
 * @method static class-string<ScopeGroupMembership> getScopeGroupMembershipModel()
 * @method static class-string<ScopeGroupResource> getScopeGroupResourceModel()
 * @method static class-string<ScopeContext> getScopeContextModel()
 * @method static array<class-string> listScopeableModels()
 * @method static array<class-string> listHasScopeGroupsModels()
 * @method static bool isEnabled()
 * @method static void bypassScoping(\Closure $callback)
 */
class ScopeGroups extends Facade
{
    protected static function getFacadeAccessor(): string
    {
        return \CGA\ScopeGroups\ScopeGroups::class;
    }
}
