<?php

declare(strict_types=1);

namespace CGA\ScopeGroups\Enums;

/**
 * The types should reflect the scope of the managing authority.
 * - Personal: This group is specific to the user
 * - Global: This group is encompassed by the managing authority
 *
 * Change these to match the actual scope of the managing authority.
 */
enum Type: string
{
    case PERSONAL = 'personal';
    case GLOBAL = 'global';

    public function description(): string
    {
        return __($this->value);
    }
}
